
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion
namespace gov.va.med.vbecs.DAL.UnitTests
{

	[TestFixture]
	public class DAL_LockManager : BaseTest 
	{

		private System.Guid _recordGuid = System.Guid.NewGuid();
		private Common.LockFunctions _lockFunction = Common.LockFunctions.UnitTests;
        private int _baseLockingFormId = -6969;
        private int _lockedFormId = -6969;

		[SetUp]
		protected void SetUp() 
		{				
			this.BaseSetUp();
		}

		[TearDown]
		protected void TearDown()
		{
			DAL.LockManager.UnlockAllRecordsForUser(Common.LogonUser.LogonUserName, true);
		}


		[Test]
		public void LockRecord_Pass()
		{
		    const int lockFormID = 0;
		    const int baseLockFormID = 0;
			DataTable dtTest = DAL.LockManager.LockRecord(this._recordGuid, lockFormID, this._lockFunction,false, baseLockFormID, BOL.LockManager.DefaultLockInactivityTimeoutMin);

			Assert.AreEqual(1, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(14, dtTest.Columns.Count, "Columns.Count");

            Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLock.VbecsLockGuid), TABLES.VbecsLock.VbecsLockGuid);
            Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLock.LockedRecordGuid), TABLES.VbecsLock.LockedRecordGuid);
            Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLock.LockedUseCaseId), TABLES.VbecsLock.LockedUseCaseId);
            Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLock.LockedFormId), TABLES.VbecsLock.LockedFormId);
            Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLock.BaseLockedFormId), TABLES.VbecsLock.BaseLockedFormId);
            Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLock.LockedFormId), TABLES.VbecsLock.LockedFormId);
            Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLock.SessionGuid), TABLES.VbecsLock.SessionGuid);
            Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLock.DivisionCode), TABLES.VbecsLock.DivisionCode);
            Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLock.MultiDivisionIndicator), TABLES.VbecsLock.MultiDivisionIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLock.LastUpdateDate), TABLES.VbecsLock.LastUpdateDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLock.LastUpdateUser), TABLES.VbecsLock.LastUpdateUser);
            Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLock.LastUpdateFunctionId), TABLES.VbecsLock.LastUpdateFunctionId);
			
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.LockConflictIndicator), ARTIFICIAL.LockConflictIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(ARTIFICIAL.RemainingLockTime), ARTIFICIAL.RemainingLockTime);
	    }

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void LockRecord_Fail()
		{
		}

		[Test]
		public void GetLock_Pass()
		{
            DAL.LockManager.LockRecord(this._recordGuid, this._lockedFormId, this._lockFunction, false, this._baseLockingFormId, BOL.LockManager.DefaultLockInactivityTimeoutMin);

			DataTable dtTest = DAL.LockManager.GetLock(this._recordGuid);

			Assert.AreEqual(1, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(11, dtTest.Columns.Count, "Columns.Count");

            Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLock.LockedRecordGuid), TABLES.VbecsLock.LockedRecordGuid);
            Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLock.LockedUseCaseId), TABLES.VbecsLock.LockedUseCaseId);
            Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLock.LockedFormId), TABLES.VbecsLock.LockedFormId);
            Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLock.BaseLockedFormId), TABLES.VbecsLock.BaseLockedFormId);
            Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLock.LockFunctionId), TABLES.VbecsLock.LockFunctionId);
            Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLock.LastUpdateDate), TABLES.VbecsLock.LastUpdateDate);
            Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLock.DivisionCode), TABLES.VbecsLock.DivisionCode);
            Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLock.LastUpdateUser), TABLES.VbecsLock.LastUpdateUser);
            Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLock.LastUpdateFunctionId), TABLES.VbecsLock.LastUpdateFunctionId);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLock.MultiDivisionIndicator), TABLES.VbecsLock.MultiDivisionIndicator);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.VbecsLock.SessionGuid), TABLES.VbecsLock.SessionGuid);
		}

		[Test]
		public void GetLock_Fail()
		{
			DataTable dtTest = DAL.LockManager.GetLock(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void UnlockAllRecordsForUseCaseUser_Pass()
		{
            DAL.LockManager.LockRecord(this._recordGuid, this._lockedFormId, this._lockFunction, false, this._baseLockingFormId, BOL.LockManager.DefaultLockInactivityTimeoutMin);
            DAL.LockManager.LockRecord(System.Guid.NewGuid(), this._lockedFormId, Common.LockFunctions.UC100JustifyPatientABORh, false, this._baseLockingFormId, BOL.LockManager.DefaultLockInactivityTimeoutMin);

			DAL.LockManager.UnlockAllRecordsForUseCaseUser(Common.LogonUser.LogonUserName, this._lockFunction, this._lockedFormId, this._baseLockingFormId );

			//We don't want to exception on this one
			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM VbecsLock WHERE DivisionCode = '" + this.TestDivisionCode + "' AND LastUpdateUser = '" + Common.LogonUser.LogonUserName + "'", false);
			
			Assert.AreEqual(0, dtTemp.Rows.Count, "Rows.Count");
		}

		[Test]
		public void UnlockAllRecordsForUseCaseUser_Fail()
		{
            DAL.LockManager.LockRecord(System.Guid.NewGuid(), this._lockedFormId, this._lockFunction, false, this._baseLockingFormId, BOL.LockManager.DefaultLockInactivityTimeoutMin);
            DAL.LockManager.LockRecord(System.Guid.NewGuid(), -8008, Common.LockFunctions.UC100JustifyPatientABORh, false, -8008, BOL.LockManager.DefaultLockInactivityTimeoutMin);

			DAL.LockManager.UnlockAllRecordsForUseCaseUser(Common.LogonUser.LogonUserName, this._lockFunction, this._lockedFormId, this._baseLockingFormId );

			//We don't want to exception on this one
			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM VbecsLock WHERE DivisionCode = '" + this.TestDivisionCode + "' AND LastUpdateUser = '" + Common.LogonUser.LogonUserName + "'", false);
			
			Assert.AreEqual(1, dtTemp.Rows.Count, "Rows.Count");
            DAL.LockManager.UnlockAllRecordsForUser(Common.LogonUser.LogonUserName, false);
		}
	
		[Test]
		public void UnlockRecord_Pass()
		{
			System.Guid[] recordGuids = {this._recordGuid};

            DAL.LockManager.LockRecord(this._recordGuid, this._lockedFormId, this._lockFunction, false, this._baseLockingFormId, BOL.LockManager.DefaultLockInactivityTimeoutMin);

			DAL.LockManager.UnlockRecords(recordGuids, this._lockedFormId, this._lockFunction);

			DataTable dtTest = DAL.LockManager.GetLock(this._recordGuid);
			
			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void UnlockRecord_Fail()
		{
		}

		[Test]
		public void UnlockAllRecordsForUser_Pass()
		{
            DAL.LockManager.LockRecord(this._recordGuid, this._lockedFormId, this._lockFunction, false, this._baseLockingFormId, BOL.LockManager.DefaultLockInactivityTimeoutMin);
            DAL.LockManager.LockRecord(System.Guid.NewGuid(), this._lockedFormId, Common.LockFunctions.UC100JustifyPatientABORh, false, -9999, BOL.LockManager.DefaultLockInactivityTimeoutMin);

			DAL.LockManager.UnlockAllRecordsForUser(Common.LogonUser.LogonUserName, true);

			//We don't want to exception on this one
			DataTable dtTemp = UnitTestUtil.RunSQLGetDataTable("SELECT * FROM VbecsLock WHERE DivisionCode = '" + this.TestDivisionCode + "' AND LastUpdateUser = '" + Common.LogonUser.LogonUserName + "'", false);
			
			Assert.AreEqual(0, dtTemp.Rows.Count, "Rows.Count");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void UnlockAllRecordsForUser_Fail()
		{
		}

	}
}
#endif


